/********************************************
; File: Types.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#define __TYPES__

#ifndef noError
#define noError 0x0000
#endif
#ifndef nil
#define nil 0x0L
#endif
#ifndef NULL /* -  */
#define NULL 0x0L
#endif
#ifndef NIL
#define NIL 0x0L
#endif
#define dispatcher 0xE10000L  /* tool locator dispatch address */
#define TRUE 1
#define true TRUE
#define FALSE 0
#define false FALSE


/* RefDescriptors */
#define refIsPointer 0x0000
#define refIsHandle 0x0001
#define refIsResource 0x0002
#define refIsNewHandle 0x0003
typedef unsigned char byte, Byte;
typedef unsigned int word, Word ;
typedef int integer, Integer;
typedef long longint, Longint ;
typedef long Long;
typedef unsigned long longword, Longword, LongWord ;
typedef unsigned long Dblword, DblWord ; /* retained for back compatibility */
typedef long Fixed;
typedef long Frac;
typedef extended Extended;
typedef extended *ExtendedPtr ;
typedef char *ptr, *Ptr, *pointer, *Pointer;
typedef ptr *handle, *Handle;
typedef Handle *HandlePtr ;
typedef char *CStringPtr, **CStringHndl, ***CStringHndlPtr ;
typedef long (*ProcPtr)();  /* retained for back compatibility */
typedef pascal void (*VoidProcPtr)();
typedef pascal Word (*WordProcPtr)();
typedef pascal LongWord (*LongProcPtr)();

typedef unsigned int boolean, Boolean, BOOLEAN;
typedef short OSErr;
typedef int *IntPtr ;
typedef Ptr FPTPtr;
#define String(size) struct { unsigned char textLength; unsigned char text[size]; }
typedef String(255) Str255, *StringPtr, **StringHandle;


typedef String(32) Str32, *String32Ptr, **String32Handle;

struct Point {
   short v;
   short h;
} ;
typedef struct Point Point, *PointPtr;
struct Rect {
   short v1;
   short h1;
   short v2;
   short h2;
} ;
typedef struct Rect Rect, *RectPtr, **RectHndl;
struct TimeRec {
   Byte second;
   Byte minute;
   Byte hour;
   Byte year;
   Byte day;
   Byte month;
   Byte extra;
   Byte weekDay;
} ;
typedef struct TimeRec TimeRec, *TimeRecPtr, **TimeRecHndl;
typedef Word RefDescriptor ;



typedef Long Ref ;
extern unsigned _ownerid;
extern int _toolErr;
#endif
